import React, { useState } from "react";
import { WebView } from "react-native-webview";
import { videoStyle } from "./video.style";
import { View } from "react-native";
import SkeletonElement from "../../../../../../src/skeletons/SkeletonElement";


const Videos = ({ videos }) => {
    const [videoIsLoaded, setVideoIsLoaded] =  useState(false);
    return (
        <View style={videoStyle.container}>
            {!videoIsLoaded && videos.map((video, index) => {
                return (
                    <View key={index}>
                        <WebView
                            javaScriptEnabled={true}
                            domStorageEnabled={true}
                            source={{
                                html: `<iframe width="100%" height="100%" src=${video} frameborder="0"></iframe>`
                            }}
                            style={videoStyle.videoPlaceholder}
                            onLoad={() => setVideoIsLoaded(true)}
                        />
                        <SkeletonElement
                            wrapperStyle={videoStyle.skeletonWrapper}
                        />
                    </View>
                );
            })}
            {videoIsLoaded && videos.map((video, index) => {
                return (
                    <View key={index}>
                        <WebView
                            javaScriptEnabled={true}
                            domStorageEnabled={true}
                            source={{
                                html: `<iframe width="100%" height="100%" src=${video} frameborder="0" allowFullScreen></iframe>`
                            }}
                            allowsFullscreenVideo={true}
                            style={videoStyle.video}
                        />
                    </View>
                );
            })}
        </View>
    );
};

export default Videos;
